#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <iostream>

using namespace std;

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindowClass)
{
    ui->setupUi(this);
    manager=new QNetworkAccessManager(this);

}

MainWindow::~MainWindow()
{
    delete ui;
    delete manager;
}


void MainWindow::request0Finished()
{
    redrawTile(0);
}

void MainWindow::request1Finished()
{
    redrawTile(1);
}

void MainWindow::redrawTile(int i)
{

    cout<<"Request "<<i<<" finished with "<<networkReply[i]->error()<<endl;

    QByteArray bytes=networkReply[i]->readAll();
    QPixmap myMap;
    myMap.loadFromData(bytes);

    QGraphicsPixmapItem *itemPtr=myScene.addPixmap(myMap);
    itemPtr->setPos(i*256,0);
    networkReply[i]->deleteLater();
}

void MainWindow::on_pushButton_clicked()
{
     myScene.clear();

    QNetworkRequest request[2];
    request[0].setUrl(QUrl("http://tile.openstreetmap.org/12/2199/1312.png"));
    request[1].setUrl(QUrl("http://tile.openstreetmap.org/12/2200/1312.png"));


    networkReply[0] = manager->get(request[0]);
    networkReply[1] = manager->get(request[1]);
    connect((const QObject*)networkReply[0], SIGNAL(finished()), this, SLOT(request0Finished()));
    connect((const QObject*)networkReply[1], SIGNAL(finished()), this, SLOT(request1Finished()));

    cout<<"Requests started"<<endl;
    ui->graphicsView->setScene(&myScene);
    ui->graphicsView->show();
    cout<<"Button handler left"<<endl;

}
